/**********************************************************************/
/*  FILE   : MQMONA.H                                                 */
/*  PURPOSE: MQMONA External Header File                              */
/*  AUTHOR : Paul Clarke                                              */
/**********************************************************************/
#define MQG_WHERE_LENGTH                          1024
#define MQG_CERT_SERIAL_LENGTH                      64
#define MQG_ZOS_USER_ID_LENGTH                       8

#define MQG_ATTR_ERROR_TEXT                      39999
#define MQG_ATTR_RESPONSE_DELIMITER              40000

#define MQG_ATTR_MQMONA_FIRST                    20000
#define MQG_ATTR_MQMONA_CMDLEVEL                 20000
#define MQG_ATTR_MQMONA_FEATURES                 20001
#define MQG_ATTR_MQMONA_WHERE                    20002
#define MQG_ATTR_MQMONA_CERT_ATTRS               20003
#define MQG_ATTR_MQMONA_KEYRING_USER             20004
#define MQG_ATTR_MQMONA_CERT_USER                20005
#define MQG_ATTR_MQMONA_CERT_ISSUE_TIME          20006
#define MQG_ATTR_MQMONA_CERT_EXPIRY_TIME         20007
#define MQG_ATTR_MQMONA_CERT_LIFESPAN            20008
#define MQG_ATTR_MQMONA_CERT_KEYSIZE             20009
#define MQG_ATTR_MQMONA_CERT_DEFAULT             20010
#define MQG_ATTR_MQMONA_CERT_USAGE               20011
#define MQG_ATTR_MQMONA_CERT_TRUSTED             20012
#define MQG_ATTR_MQMONA_CERT_SERIAL              20013
#define MQG_ATTR_MQMONA_CERT_QMGR                20014
#define MQG_ATTR_MQMONA_LIFESPAN_THRESHOLD       20015
#define MQG_ATTR_MQMONA_BUILD                    20016

#define MQG_ATTR_MQMONA_LAST_USED                20016

#define MQG_FEATURES_UNLICENSED                  0x00000001
#define MQG_FEATURES_COALESCING                  0x00000002
#define MQG_FEATURES_PCF_BLANKS_REMOVAL          0x00000004
#define MQG_FEATURES_DISPLAY_CERT                0x00000008
#define MQG_FEATURES_CERT_EXPIRY_EVENTS          0x00000010

#define MQGRCCF_COMMAND_OK_WITH_TEXT             10000
#define MQGRCCF_NO_RESPONSE_FROM_CMDSERVER       10100

#define MQGRC_CERTIFICATE_NEARING_EXPIRY         11000

#define MQG_CMD_DISPLAY_CERTIFICATE              9500

#define MQCFC_COALESCED                          0x00010000

#define MQG_DEFAULT_CERT_NO                      0
#define MQG_DEFAULT_CERT_YES                     1

#define MQG_CERT_USAGE_PERSONAL                  1
#define MQG_CERT_USAGE_CACERT                    2
#define MQG_CERT_USAGE_VALIDATION                3
#define MQG_CERT_USAGE_ALL                       -1

#define MQG_TRUSTED_CERT_NO                      0
#define MQG_TRUSTED_CERT_YES                     1
#define MQG_TRUSTED_CERT_HIGH                    2

#define MQG_QMGR_CERT_NO                         0
#define MQG_QMGR_CERT_YES                        1
